/**
 * FUZIION Redirects – Admin
 */

(function($) {
    'use strict';

    function getEmptyStateHtml() {
        var title = (typeof fuziionRedirects !== 'undefined' && fuziionRedirects.emptyStateTitle) ? fuziionRedirects.emptyStateTitle : 'No redirects yet';
        var text = (typeof fuziionRedirects !== 'undefined' && fuziionRedirects.emptyStateText) ? fuziionRedirects.emptyStateText : 'Add your first redirect above.';
        return '<div class="fuziion-redirects-empty" data-empty="1">' +
            '<div class="fuziion-redirects-empty-icon" aria-hidden="true"></div>' +
            '<p class="fuziion-redirects-empty-title">' + title + '</p>' +
            '<p class="fuziion-redirects-empty-text">' + text + '</p>' +
            '</div>';
    }

    $(document).ready(function() {
        $(document).on('click', '.delete-redirect', function(e) {
            e.preventDefault();

            if (!confirm(fuziionRedirects.confirmDelete)) {
                return;
            }

            var $button = $(this);
            var index = $button.data('index');
            var $row = $button.closest('.fuziion-redirects-row');
            var $tbody = $row.closest('tbody');
            var $tableWrap = $row.closest('.fuziion-redirects-table-wrap');
            var $listCard = $row.closest('.fuziion-redirects-list-card');

            $button.prop('disabled', true).text('...');

            $.ajax({
                url: fuziionRedirects.ajaxUrl,
                type: 'POST',
                data: {
                    action: 'fuziion_redirects_delete',
                    nonce: fuziionRedirects.nonce,
                    index: index
                },
                success: function(response) {
                    if (response.success) {
                        $row.fadeOut(200, function() {
                            $(this).remove();
                            if ($tbody.find('tr').length === 0) {
                                $listCard.find('.fuziion-redirects-list-head .fuziion-redirects-count').remove();
                                $tableWrap.replaceWith(getEmptyStateHtml());
                            }
                        });
                    } else {
                        alert(response.data && response.data.message ? response.data.message : 'Er is een fout opgetreden.');
                        $button.prop('disabled', false).text('Verwijderen');
                    }
                },
                error: function() {
                    alert('Er is een fout opgetreden bij het verwijderen van de redirect.');
                    $button.prop('disabled', false).text('Verwijderen');
                }
            });
        });

        $('#redirect_from, #redirect_to').on('blur', function() {
            var $input = $(this);
            var value = $input.val().trim();
            if (value && !value.match(/^https?:\/\//) && !value.startsWith('/')) {
                $input.val('/' + value);
            }
        });
    });

})(jQuery);
