<?php
/**
 * Plugin Name: FUZIION Redirects
 * Plugin URI: https://fuziion.nl
 * Description: Simple redirect management plugin for WordPress
 * Version: 1.0.0
 * Author: FUZIION
 * Author URI: https://fuziion.nl
 * Text Domain: fuziion-redirects
 * License: GPL v2 or later
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

// Plugin constants
define('FUZIION_REDIRECTS_VERSION', '1.0.0');
define('FUZIION_REDIRECTS_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('FUZIION_REDIRECTS_PLUGIN_URL', plugin_dir_url(__FILE__));
define('FUZIION_REDIRECTS_PLUGIN_BASENAME', plugin_basename(__FILE__));

add_action('init', function (): void {
    load_plugin_textdomain(
        'fuziion-redirects',
        false,
        dirname(FUZIION_REDIRECTS_PLUGIN_BASENAME) . '/languages'
    );
}, 0);

spl_autoload_register(function (string $class): void {
    $prefix = 'FuziionRedirects\\';
    $base_dir = FUZIION_REDIRECTS_PLUGIN_DIR . 'src/';

    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }

    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';

    if (is_file($file)) {
        require_once $file;
    }
});

require_once FUZIION_REDIRECTS_PLUGIN_DIR . 'includes/fuziion-updater-class.php';
new Fuziion_Plugin_Updater(
    'https://fuziion.nl/api/',
    'fuziion-redirects',
    FUZIION_REDIRECTS_PLUGIN_BASENAME,
    FUZIION_REDIRECTS_VERSION
);

$container = new FuziionRedirects\Container();
$container->get(FuziionRedirects\Plugin::class)->run();
