<?php
/**
 * AJAX handler for deleting a redirect.
 *
 * @package FuziionRedirects
 */

namespace FuziionRedirects\Admin;

use FuziionRedirects\RedirectRepository;

defined('ABSPATH') || exit;

class AdminAjaxHandler
{
    public function __construct(
        private RedirectRepository $repository
    ) {
    }

    /**
     * Handle wp_ajax_fuziion_redirects_delete: verify nonce, capability, then delete by index.
     *
     * @return void
     */
    public function handleDelete(): void
    {
        check_ajax_referer('fuziion_redirects_nonce', 'nonce');

        if (!current_user_can('manage_options')) {
            wp_send_json_error(['message' => __('Permission denied.', 'fuziion-redirects')]);
        }

        $index = isset($_POST['index']) ? (int) $_POST['index'] : -1;

        if ($index < 0) {
            wp_send_json_error(['message' => __('Invalid index.', 'fuziion-redirects')]);
        }

        $redirects = $this->repository->getRedirects();

        if (!isset($redirects[$index])) {
            wp_send_json_error(['message' => __('Redirect not found.', 'fuziion-redirects')]);
        }

        unset($redirects[$index]);
        $redirects = array_values($redirects);

        $this->repository->saveRedirects($redirects);

        wp_send_json_success(['message' => __('Redirect deleted.', 'fuziion-redirects')]);
    }
}
