<?php
/**
 * Enqueues admin CSS and JS for the redirects page.
 *
 * @package FuziionRedirects
 */

namespace FuziionRedirects\Admin;

defined('ABSPATH') || exit;

class AdminAssets
{
    /**
     * Enqueue assets only on the redirects admin page.
     *
     * @param string $hook Current admin page hook.
     * @return void
     */
    public function enqueue(string $hook): void
    {
        if ($hook !== 'tools_page_fuziion-redirects') {
            return;
        }

        wp_enqueue_style(
            'fuziion-redirects-admin',
            FUZIION_REDIRECTS_PLUGIN_URL . 'assets/css/admin.css',
            [],
            FUZIION_REDIRECTS_VERSION
        );

        wp_enqueue_script(
            'fuziion-redirects-admin',
            FUZIION_REDIRECTS_PLUGIN_URL . 'assets/js/admin.js',
            ['jquery'],
            FUZIION_REDIRECTS_VERSION,
            true
        );

        wp_localize_script('fuziion-redirects-admin', 'fuziionRedirects', [
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('fuziion_redirects_nonce'),
            'confirmDelete' => __('Are you sure you want to delete this redirect?', 'fuziion-redirects'),
            'emptyStateTitle' => __('No redirects yet', 'fuziion-redirects'),
            'emptyStateText' => __('Add your first redirect above. Visitors will be redirected automatically.', 'fuziion-redirects'),
        ]);
    }
}
