<?php
/**
 * Registers the redirects admin menu and subpage.
 *
 * @package FuziionRedirects
 */

namespace FuziionRedirects\Admin;

defined('ABSPATH') || exit;

class AdminMenu
{
    public function __construct(
        private AdminPageRenderer $pageRenderer
    ) {
    }

    /**
     * Add Tools submenu and page callback.
     *
     * @return void
     */
    public function register(): void
    {
        add_management_page(
            __('FUZIION Redirects', 'fuziion-redirects'),
            __('Redirects', 'fuziion-redirects'),
            'manage_options',
            'fuziion-redirects',
            [$this->pageRenderer, 'render']
        );
    }
}
