<?php
/**
 * Normalizes URL paths for redirect matching and storage.
 *
 * @package FuziionRedirects
 */

namespace FuziionRedirects;

defined('ABSPATH') || exit;

class PathNormalizer
{
    /**
     * Normalize a path: trim slashes, add leading slash.
     *
     * @param string $path
     * @return string
     */
    public function normalize(string $path): string
    {
        $path = trim($path, '/');
        return $path === '' ? '/' : '/' . $path;
    }
}
