<?php
/**
 * Main plugin bootstrap: wires hooks to container-resolved services.
 *
 * @package FuziionRedirects
 */

namespace FuziionRedirects;

use FuziionRedirects\Admin\AdminMenu;
use FuziionRedirects\Admin\AdminAssets;
use FuziionRedirects\Admin\AdminFormHandler;
use FuziionRedirects\Admin\AdminAjaxHandler;

defined('ABSPATH') || exit;

class Plugin
{
    public function __construct(
        private RedirectHandler $redirectHandler,
        private AdminMenu $adminMenu,
        private AdminAssets $adminAssets,
        private AdminFormHandler $adminFormHandler,
        private AdminAjaxHandler $adminAjaxHandler
    ) {
    }

    /**
     * Register WordPress hooks.
     *
     * @return void
     */
    public function run(): void
    {
        add_action('admin_menu', [$this->adminMenu, 'register']);
        add_action('admin_init', [$this->adminFormHandler, 'handleSubmission']);
        add_action('admin_enqueue_scripts', [$this->adminAssets, 'enqueue']);
        add_action('template_redirect', [$this->redirectHandler, 'handleRedirects'], 1);
        add_action('wp_ajax_fuziion_redirects_delete', [$this->adminAjaxHandler, 'handleDelete']);
    }
}
