<?php
/**
 * Storage for redirect rules (WordPress options).
 *
 * @package FuziionRedirects
 */

namespace FuziionRedirects;

defined('ABSPATH') || exit;

class RedirectRepository
{
    private string $option_name;

    public function __construct()
    {
        $this->option_name = 'fuziion_redirects';
    }

    /**
     * Get all redirects.
     *
     * @return array<int, array{from: string, to: string, type: int, created: string}>
     */
    public function getRedirects(): array
    {
        $redirects = get_option($this->option_name, []);
        return is_array($redirects) ? $redirects : [];
    }

    /**
     * Save redirects.
     *
     * @param array<int, array{from: string, to: string, type: int, created?: string}> $redirects
     * @return void
     */
    public function saveRedirects(array $redirects): void
    {
        update_option($this->option_name, $redirects);
    }

    /**
     * Get the option name (for tests or debugging).
     *
     * @return string
     */
    public function getOptionName(): string
    {
        return $this->option_name;
    }
}
